(function () {
  const y = document.getElementById("year");
  if (y) y.textContent = new Date().getFullYear();
})();

function openWhatsAppPrevidencia(e) {
  e.preventDefault();
  const f = e.target;
  const nome = encodeURIComponent(f.nome.value.trim());
  const assunto = encodeURIComponent(f.assunto.value);
  const msg = encodeURIComponent((f.msg.value || "").trim());

  const text = `Olá! Meu nome é ${nome}. Quero ajuda com Previdência (INSS). Assunto: ${assunto}. ${msg ? "Caso: " + msg : ""}`;
  window.open(`https://wa.me/5511979948749?text=${text}`, "_blank");
  return false;
}

function openWhatsAppSaude(e) {
  e.preventDefault();
  const f = e.target;
  const nome = encodeURIComponent(f.nome.value.trim());
  const cnpj = encodeURIComponent(f.cnpj.value);
  const vidas = encodeURIComponent(f.vidas.value);
  const pref = encodeURIComponent(f.pref.value);

  const text = `Olá! Meu nome é ${nome}. Quero cotação de Plano de Saúde. CNPJ/MEI: ${cnpj}. Vidas: ${vidas}. Preferência: ${pref}.`;
  window.open(`https://wa.me/5511979948749?text=${text}`, "_blank");
  return false;
}










function sumAges(form){
  const fields = ["a00_18","a19_23","a24_28","a29_33","a34_38","a39_43","a44_48","a49_53","a54_58","a59"];
  let total = 0;
  const parts = [];

  fields.forEach((name) => {
    const el = form.querySelector(`[name="${name}"]`);
    const v = Math.max(0, parseInt(el?.value || "0", 10) || 0);
    total += v;

    const labelMap = {
      a00_18: "00-18",
      a19_23: "19-23",
      a24_28: "24-28",
      a29_33: "29-33",
      a34_38: "34-38",
      a39_43: "39-43",
      a44_48: "44-48",
      a49_53: "49-53",
      a54_58: "54-58",
      a59: "59+",
    };

    if (v > 0) parts.push(`${labelMap[name]}: ${v}`);
  });

  return { total, parts };
}

function resetIdades(){
  const form = document.querySelector("form.form");
  if(!form) return;
  ["a00_18","a19_23","a24_28","a29_33","a34_38","a39_43","a44_48","a49_53","a54_58","a59"].forEach(n=>{
    const el = form.querySelector(`[name="${n}"]`);
    if(el) el.value = 0;
  });
  const totalEl = document.getElementById("totalVidas");
  if(totalEl) totalEl.textContent = "0";
}

function bindTotalVidas(){
  const form = document.querySelector("form.form");
  if(!form) return;

  const inputs = form.querySelectorAll('.agegrid input[type="number"]');
  const totalEl = document.getElementById("totalVidas");

  const update = () => {
    const { total } = sumAges(form);
    if(totalEl) totalEl.textContent = String(total);
  };

  inputs.forEach(i => i.addEventListener("input", update));
  update();
}

document.addEventListener("DOMContentLoaded", bindTotalVidas);

function openWhatsAppSaude(e) {
  e.preventDefault();
  const f = e.target;

  const nome = encodeURIComponent(f.nome.value.trim());
  const cnpj = encodeURIComponent(f.cnpj.value);
  const pref = encodeURIComponent(f.pref.value);

  const { total, parts } = sumAges(f);

  const idadesTexto = parts.length ? parts.join(" | ") : "Não informado";
  const totalTexto = total ? `${total}` : "0";

  const text =
    `Olá! Meu nome é ${nome}. Quero cotação de Plano de Saúde.` +
    ` CNPJ/MEI: ${cnpj}.` +
    ` Vidas (total): ${totalTexto}.` +
    ` Faixas: ${idadesTexto}.` +
    ` Preferência: ${pref}.`;

  window.open(`https://wa.me/5511979948749?text=${encodeURIComponent(text)}`, "_blank");
  return false;
}
